<?php   
    
    require_once('graph_def.inc');
    require_once('class.fpdf_graph.php');
   	//Class Extention for header and footer	
	require_once("header_footer.inc");
   	
   	$pdf = new pdf_usage();
   	
   	$pdf->GraphLoadSettings($aGraphDefaultDefinitions);
   	
	$pdf->Open();
	$pdf->SetAutoPageBreak(true, 20);
    $pdf->SetTopMargin(0);
    $pdf->AliasNbPages(); 
	$pdf->AddPage();
	$pdf->SetFont('Arial', 'B', 8);
    
    $pdf->SetGraphLimits(-15, 60, -40, 70);

       
	$aCoords = array(
				'x'  => array(-10,	-7,	0,	7,	10, 	20, 	25,		35, 	40, 	50), // X Scale
				'c0' => array(-10, 	-7, 0, 10, 	-40, 	-32, 	-7.5, 	2.9, 	3.5, 	4.9),//Curve 1
				'c1' => array(50, 23.2, 8.8, 34.5, 30, 27.1, 40, 22.5, 37, 23.2, -19.6), // Curve 2
				'c2' => array(-5.8, -0.6, 50.5, 60, 53.1, 43.2, 46.6, 48.4, 50, 55, 60), // Curve 3
				'c3' => array(29.7, 4.6, -9.7, 16.8, 3.3, 4.6, 10, 10.3, 17.6, 31.5, 46.6 ), //  Curve 4
				);
				
	
	$aCoords1 = array(
				'x'  => array(-10, 0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130), // X Scale
				'cc0' => array(61.8, 18.9, 35.8, 70.9, 9.5, 73.7, 1.3, 94, 89.8, 77.5, 32.9, 36.2, 45.2, 60.6, 9.8, ),//Curve 1
				'cc1' => array(19.7, 94.4, 87, 47.4, 89.3, 34.6, 65.1, 12.6, 27.3, 22, 22, 44.9, 59.9, 74.1, 7.2, ),//Curve 2
				'cc2' => array(10.8, 59.5, 89.2, 52.8, 44.1, 54, 28.1, 94.9, 27.6, 40, 29.5, 65.9, 18.9, 84.1, 50.7, ),//Curve 3
				'cc3' => array(19.2, 62.5, 42.8, 15.3, 92.5, 27.9, 59.3, 25.8, 83.6, 32.2, 47.4, 62.6, 10.6, 72.2, 92.2, ),//Curve 4
				);				

	$aParams = array(
					'c0' => array(
								'DIAGRAM_COLOR' => array(230, 0, 0)
							),
							
					'c2' => array(
								'DIAGRAM_COLOR' => array(230, 230, 0),
								'DIAGRAM_SIZE' => 0.5,
							)			
				);
				
				
	$aParams1 = array(
					'GRID_LINES_BY_VALUE' => false,
					'cc0' => array(
								'DIAGRAM_COLOR' => array(230, 0, 0)
							),
					'cc1' => array(
								'DIAGRAM_COLOR' => array(20, 0, 240)
							),							
					'cc2' => array(
								'DIAGRAM_COLOR' => array(230, 230, 0),
								'DIAGRAM_SIZE' => 0.5,
							),
					'cc3' => array(
								'DIAGRAM_COLOR' => array(0, 120, 255),
								'DIAGRAM_SIZE' => 0.5,
							),			
				);
    
    $pdf->GraphDiagramm($aCoords, 'Graph 1 Text for X Coords', 'Graph 1 Text for Y Coords', 20, 30, 60, 50);
    $pdf->GraphDiagramm($aCoords, 'Same Graph as 1, just other parameters', 'Y Coords', 95, 20, 100, 100, $aParams);
    
    $pdf->SetGraphLimits(-15, 140, -5, 100);
	$pdf->GraphDiagramm($aCoords1, 'Graph 2 Text for X Coords', 'Graph 2 Text for Y Coords', 20, 130, 60, 50);
	$pdf->GraphDiagramm($aCoords1, 'Same Graph as 2, just other parameters, GRID_LINES_BY_VALUE==false', 'Y Coords', 100, 140, 100, 80, $aParams1);
    
	$pdf->Output();

?>